
from pabutools.election import parse_pabulib
import os


def import_pabulib_files_from_folder(folder_path, single_file=None):
    # List all files in the given directory
    files = [f for f in os.listdir(folder_path) if os.path.isfile(os.path.join(folder_path, f))]
    # Sort the files for consistency
    # remove the .DS_Store file
    if '.DS_Store' in files:
        files.remove('.DS_Store')

    files.sort()
    # Rename each file
    instances = {}
    profiles = {}
    for idx, file_name in enumerate(files):
        # print(file_name)
        if single_file is not None:
            if single_file != file_name:
                continue
        path = os.path.join(folder_path, file_name)
        # print(path)
        instance, profile = parse_pabulib(path)

        nice_name = file_name.split('.')[0]
        instances[nice_name] = instance
        profiles[nice_name] = profile

    return instances, profiles

def get_files_names_from_folder(folder_path, single_file=None):
    # List all files in the given directory
    files = [f for f in os.listdir(folder_path) if os.path.isfile(os.path.join(folder_path, f))]
    # Sort the files for consistency
    # remove the .DS_Store file
    if '.DS_Store' in files:
        files.remove('.DS_Store')

    files.sort()
    # Rename each file
    instances = []
    for idx, file_name in enumerate(files):
        # print(file_name)
        nice_name = file_name.split('.')[0]
        instances.append(nice_name)

    return instances